<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" EnableSessionState="True" Theme="Voxco"
    Trace="false" Async="true" Inherits="Voxco.Reporting.Report_ReportInterviewers"
    Title="<%$ Resources:Resource, VoxcoReporting%>" Codebehind="ReportInterviewers.aspx.cs" %>

<%@ Register Src="~/WaitingPanel.ascx" TagPrefix="VxRpt" TagName="WaitingPanel" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>


<asp:Content ID="Content1" ContentPlaceHolderID="MainContent" runat="Server" EnableViewState="true">
	
	<telerik:RadScriptBlock ID="ScriptManager" runat="server">
		<script type="text/javascript">

		    if (Telerik.Web.UI.RadTreeView != undefined) {
		        Telerik.Web.UI.RadTreeView.prototype.saveClientState = function () {
		            return "{\"expandedNodes\":" + this._expandedNodesJson +
		                ",\"collapsedNodes\":" + this._collapsedNodesJson +
		                ",\"logEntries\":" + this._logEntriesJson +
		                ",\"selectedNodes\":" + this._selectedNodesJson +
		                ",\"checkedNodes\":" + this._checkedNodesJson +
		                ",\"scrollPosition\":" + Math.round(this._scrollPosition) + "}";
		        }
		    }

			function treeSelectedDropTest(source, dest, events)
			{
				 if(dest._destNode.get_value().substring(0,3) == "OG:" && source.get_parent() != null &&  source.get_parent() != dest._destNode.get_value())
                {
                    return true;
                }
                // allow moving all group's elements in another group
                if(source.get_selectedNode().get_value().substring(0, 3) == "OG:" && dest.get_destNode().get_value().substring(0, 3) == "OG:")
                {
                    return true;
                }
                return false;
			}
	        
			function ContextMenuClick(node, itemText)
			{
				if (itemText == "Disable")
				{
					node.Disable();
					return false;
				}
				if (itemText == "Enable All")
				{
					for (var i=0; i<node.TreeView.AllNodes.length; i++)
					{
						node.TreeView.AllNodes[i].Enable();
					}
				}
				if (itemText == "Edit")
				{        
					node.StartEdit();
				}
	            
				return true;
			}
	        
			function UpdateAllChildren(nodes, checked)
			{		
				for (i=0; i<nodes.length; i++)
				{
					checked ? nodes[i].Check() : nodes[i].UnCheck(); 
					if (nodes[i].Nodes.length > 0)
					{
						UpdateAllChildren(nodes[i].Nodes, checked);    
					}
				}
			}
	        
			function UncheckGroupNodesAllNodes(sender, eventArgs)
			{
				var tree = $find('<%= treeSelectedInterviewers.ClientID %>'); 
			    var _nodes = tree.get_allNodes();
				for (var i = 0; i < _nodes.length; i++)
				{
					if( _nodes[i].get_value().substring(0, 3) == "OG:" )
					{
						_nodes[i].uncheck();
					}
				}
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("SetSelectedNodes");
			}

			function CheckGroupNodesAllNodes(sender, eventArgs)
			{
				var tree = $find('<%= treeSelectedInterviewers.ClientID %>');
			    var _nodes = tree.get_allNodes();
				for (var i = 0; i < _nodes.length; i++)
				{
					if( _nodes[i].get_value().substring(0, 3) == "OG:" )
					{
						_nodes[i].check();						
					}
				}
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("SetSelectedNodes");
			}
	        
			function grdFilteredInterviewers_OnColumnClick(index)
			{
				if(index == 0)
				{					
					$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("ToggleSelectAllFiltered");
				}
			}
			function grdAvailableInterviewers_OnColumnClick(index)
			{
				if(index == 0)
				{					
					$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("ToggleSelectAllAvailable");
				}
			}
	        
			var searchValue = null;
//			function FindTextBox_OnValueChanged(sender, e)
//			{
//				searchValue = e.NewValue;
//				FindAgent(e.NewValue);				
//			}
	        
			function FindTextBox_OnButtonClick(sender, e)
			{
				var _textBox = $find("<%= FindTextBox.ClientID %>");
				var _val = _textBox.get_editValue();				
				FindAgent(_val);				
			}

			function FindAgent(value)
			{				
				$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("FindAgent:"+value);
	            
				return false;
			}

			function MoveToLast()
			{
			  $find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("MoveGroupToLast");
			  return false;
			}
	        
			function clientClose(oWnd,eventArgs)
			{
                if (eventArgs.get_argument()!= null)
                {
					$find("<%= RadAjaxPanel2.ClientID %>").ajaxRequest("MoveByXPos:" + eventArgs.get_argument());
				}
			    oWnd.remove_close(clientClose);
			}
	        
			function openWin()
			{
				var oWnd = radopen("ReportInterviewersMove.aspx", "InterviewersMove");
				oWnd.setSize(500,300);
				oWnd.set_modal(true);
				oWnd.add_close(clientClose);
				return true;
			}
	        
	        function pagerSelectionResize()
	        {
                $('.rcbInputCell :input').css('width','20px');
	        }
	        
        </script>
	</telerik:RadScriptBlock>
	
    <telerik:RadWindowManager ID="RadWindowManager1" VisibleStatusbar="false" ReloadOnShow="true" Behaviors="Close" runat="server">
            <Windows>
                <telerik:RadWindow ID="InterviewersMove" runat="server" Width="500px" Height="300px" Modal="true" OnClientClose="clientClose"
                    NavigateUrl="ReportInterviewersMove.aspx">
                </telerik:RadWindow>
            </Windows>
    </telerik:RadWindowManager>
 
    <asp:ObjectDataSource ID="AvailableInterviewerDataSource" runat="server" SelectMethod="GetAvailable"
        TypeName="Voxco.Reporting.DataSource.Interviewers">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="FilteredInterviewerDataSource" runat="server" SelectMethod="GetFiltered"
        TypeName="Voxco.Reporting.DataSource.Interviewers">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="SelectedInterviewerDataSource" runat="server" SelectMethod="GetSelected"
        TypeName="Voxco.Reporting.DataSource.Interviewers">
    </asp:ObjectDataSource>
    
    <asp:ObjectDataSource ID="AvailableInterviewerListDataSource" runat="server" SelectMethod="GetInterviewerLists"
        TypeName="Voxco.Reporting.DataSource.Interviewers">
    </asp:ObjectDataSource>
    
    <telerik:RadAjaxPanel ID="RadAjaxPanel2" runat="server" EnableAJAX="true" OnAjaxRequest="RadAjaxPanel2_OnAjaxRequest" Height="450px">
        <br />
        <asp:Panel ID="RadSplitter1" runat="server" Width="100%">
        
        <div style="float:left; width: 28%;">
            <asp:Label ID="RadPaneInterviewerAvailable" runat="server" Text="<%$ Resources:Resource, AvailableInterviewers %>" CssClass="title" />
            <br />
                <telerik:RadGrid ID="grdAvailableInterviewers" runat="server" AllowPaging="true" PageSize="50" EnableViewState="true" AllowSorting="false" 
                OnNeedDataSource="grdAvailableInterviewers_OnNeedDataSource"
                OnPageIndexChanged="grdAvailableInterviewers_PageIndexChanged" OnDataBound="grdAvailableInterviewers_OnDataBound" AllowMultiRowSelection="True" 
                AutoGenerateColumns="False" Height="360px"
                EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">   
                    <ClientSettings>
                        <Selecting UseClientSelectColumnOnly="True"  AllowRowSelect="True" />
                        <Scrolling AllowScroll="true" UseStaticHeaders="true" />
                        <ClientEvents OnColumnClick="grdAvailableInterviewers_OnColumnClick" />
                    </ClientSettings>
                    <MasterTableView NoMasterRecordsText="" Width="100%">
                        <SortExpressions>
                            <telerik:GridSortExpression FieldName="Name" SortOrder="Ascending" />
                        </SortExpressions>
                        <Columns>
                            <telerik:GridBoundColumn DataField="Id" DataType="System.Int32" Display="False" HeaderText="Id" UniqueName="Id">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ParentId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
                            </telerik:GridBoundColumn>
                            <telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
								<HeaderStyle HorizontalAlign="Left" Width="30px" />
								<ItemStyle HorizontalAlign="Left" Width="30px" />
                            </telerik:GridClientSelectColumn>
                            <telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, AvailableInterviewers %>" UniqueName="Name">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
                            </telerik:GridBoundColumn>
                        </Columns>
                    </MasterTableView>
                </telerik:RadGrid>            
        </div>
        
        <div style="width:25px; float:left; height: 240px;">            
            <div class="arrows">
				<asp:ImageButton ID="btnAddFilteredInterviewer" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddFilteredInterviewer_OnClick" />
				<asp:ImageButton ID="btnRemoveFilteredInterviewer" runat="server" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveFilteredInterviewer_OnClick" />
            </div>            
		</div>
		
		<div style="float: left; width: 28%;">
            <asp:Label ID="RadPaneInterviewerFiltered" runat="server" Text="<%$ Resources:Resource, FilteredInterviewers %>" CssClass="title" />
            <br />
                <telerik:RadGrid ID="grdFilteredInterviewers" runat="server" AllowPaging="true" PageSize="50" EnableViewState="true" Height="240px"
                    AllowSorting="false" OnNeedDataSource="grdFilteredInterviewers_OnNeedDataSource"
                    OnPageIndexChanged="grdFilteredInterviewers_PageIndexChanged" OnDataBound="grdFilteredInterviewers_OnDataBound"
                    AllowMultiRowSelection="True" AutoGenerateColumns="False"
                    EnableEmbeddedBaseStylesheet="false" EnableEmbeddedSkins="false" Skin="Voxco" ClientSettings-EnableRowHoverStyle="true">                    
                    <ClientSettings>
                        <Selecting UseClientSelectColumnOnly="True" AllowRowSelect="True" />
                        <Scrolling AllowScroll="true" UseStaticHeaders="true" />
                        <ClientEvents OnColumnClick="grdFilteredInterviewers_OnColumnClick" />
                    </ClientSettings>
                    <MasterTableView NoMasterRecordsText="" Width="100%">
                        <SortExpressions>
                            <telerik:GridSortExpression FieldName="Name" SortOrder="Ascending" />
                        </SortExpressions>
                        <Columns>
                            <telerik:GridBoundColumn DataField="Id" DataType="System.Int32" Display="False" HeaderText="Id" UniqueName="Id">
                            </telerik:GridBoundColumn>
                            <telerik:GridBoundColumn DataField="ParentId" DataType="System.Int32" Display="False" HeaderText="ProjectId" UniqueName="ProjectId">
                            </telerik:GridBoundColumn>
                            <telerik:GridClientSelectColumn DataType="System.Boolean" UniqueName="Selected">
								<HeaderStyle HorizontalAlign="Left" Width="30px" />
								<ItemStyle HorizontalAlign="Left" Width="30px" />
                            </telerik:GridClientSelectColumn>
                            <telerik:GridBoundColumn DataField="Name" HeaderText="<%$ Resources:Resource, FilteredInterviewers %>" UniqueName="Name">
								<HeaderStyle Width="90%" HorizontalAlign="Left" />
								<ItemStyle Width="90%" HorizontalAlign="Left" />
                            </telerik:GridBoundColumn> 
                        </Columns>
                    </MasterTableView>
                </telerik:RadGrid>
            <br />
            <asp:Panel ID="toto" runat="server" GroupingText=" ">
           <div>
                <div style="float:left; width:90%;">
					
					<asp:Label ID="FindLabel" runat="server" Text="<%$ Resources:Resource, Find%>" CssClass="paddingLabel"></asp:Label>
					<telerik:RadTextBox ID="FindTextBox" Width="150px" runat="server" ButtonsPosition="Right" ShowButton="true" >
						<ClientEvents OnButtonClick="FindTextBox_OnButtonClick" />
					</telerik:RadTextBox>
					
					<asp:RadioButtonList ID="choiceViewAllAgents" runat="server" RepeatDirection="Vertical" Height="30px" 
                    AutoPostBack="true" OnSelectedIndexChanged="choiceViewAllAgents_OnSelectedIndexChanged">
                        <asp:ListItem Value="AllInterviewers" Text="<%$ Resources:Resource, AllInterviewers%>" Selected="True"></asp:ListItem>
                        <asp:ListItem Value="NotSelectedForReport" Text="<%$ Resources:Resource, InterviewersNotSelectedForReport%>"></asp:ListItem>
					</asp:RadioButtonList>
                	
                	<asp:RadioButtonList ID="rdlInterviewersList" runat="server" Visible="False">
						<asp:ListItem Value="Group"></asp:ListItem>
						<asp:ListItem Value="Individuals" Text="Individuals"></asp:ListItem>
					</asp:RadioButtonList>
					
					<asp:Label ID="Label1" runat="server" Text="<%$ Resources:Resource, InterviewerList %>" cssClass="paddingLabel"></asp:Label><br />
					<asp:DropDownList ID="cboInterviewerList" runat="server" Width="162px" DataSourceID="AvailableInterviewerListDataSource" DataTextField="Name" DataValueField="ID" CssClass="paddingLabel"></asp:DropDownList>
				</div>		
				<div style="float: left; margin-top: 35px;">
					<asp:ImageButton ID="btnAddInterviewerList" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddInterviewers_OnClick" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" /><br />
					<asp:ImageButton ID="btnAddInterviewerListAsNewGroup" runat="server" ImageUrl="~/icons/arrow_right_green.png" OnClick="btnAddInterviewerListAsNewGroup_OnClick" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" />
				</div>				
			</div>
            </asp:Panel>
		</div>
		<div style="float: left; width: 50px; height: 100%;">
			<div style="width: 25px; float: left; height: 350px;">
           
                <div class="arrows">
					<asp:ImageButton ID="btnAddInterviewer" runat="server" ImageUrl="~/icons/arrow_right_blue.png" OnClick="btnAddInterviewer_OnClick" ToolTip="<%$ Resources:Resource, AddSelectedItems %>" />
	                <asp:ImageButton ID="btnAddInterviewerToNewGroup" runat="server" ImageUrl="~/icons/arrow_right_green.png" OnClick="btnAddInterviewerToNewGroup_OnClick" ToolTip="<%$ Resources:Resource, AddSelectedItemsToNewGroup %>" />
                </div>
           </div>
           <div style="float: left; height: 350px; margin-top: 15px;">
                <div class="arrows">
                    <asp:ImageButton ID="btnRemoveInterviewer" runat="server" ImageUrl="~/icons/arrow_left_blue.png" OnClick="btnRemoveInterviewer_OnClick" />
                </div>
            </div>
		</div>
		<div style="float: left; width: 28%;">
            <asp:Panel ID="RadPane3" runat="server">
                <asp:Panel ID="RadSplitter2" runat="server">
                    <asp:Panel ID="RadPane1" runat="server">
                        <asp:RadioButtonList ID="choiceSelectionType" runat="server" RepeatDirection="Horizontal" 
                         AutoPostBack="true" OnSelectedIndexChanged="choiceSelectionType_OnSelectedIndexChanged">
                            <asp:ListItem Value="AllInterviewers" Text="<%$ Resources:Resource, AllInterviewers%>" Selected="True"></asp:ListItem>
                            <asp:ListItem Value="SelectInterviewers" Text="<%$ Resources:Resource, SelectInterviewers%>"></asp:ListItem>
                        </asp:RadioButtonList>
                    </asp:Panel>
                    <asp:Panel ID="RadPaneInterviewerSelection" runat="server">
                        <asp:Label ID="labelSelectedItems" runat="server" CssClass="title" Text="<%$ Resources:Resource, DisplayedInterviewers %>" />
                        <br />
                        <asp:LinkButton ID="linkSelectAll" OnClientClick="javascript:CheckGroupNodesAllNodes();" runat="server" Text="<%$ Resources:Resource, SelectAll %>" ></asp:LinkButton>
                        <asp:LinkButton ID="LinkUnselectAll" OnClientClick="javascript:UncheckGroupNodesAllNodes();" runat="server" Text="<%$ Resources:Resource, UnselectAll %>"></asp:LinkButton>
                        <asp:LinkButton ID="Move" runat="server" Text="<%$ Resources:Resource, Move %>" OnClientClick="return openWin();"></asp:LinkButton>
                        <asp:LinkButton ID="lnkMoveUp" runat="server" Text="<%$ Resources:Resource, MoveUp %>" OnClick="lnkMoveUp_Click"></asp:LinkButton>
                        <asp:LinkButton ID="lnkMoveDown" runat="server" Text="<%$ Resources:Resource, MoveDown %>" OnClick="lnkMoveDown_Click"></asp:LinkButton>
                        <asp:LinkButton ID="MoveToLast" runat="server" Text="<%$ Resources:Resource, MoveToLast %>" OnClientClick="return MoveToLast();"></asp:LinkButton>
                        <div runat="server" visible="false" id="lblAllFilteredInInterviewersWillBeDisplayed" style="text-align:center; ">
                            <asp:Label ID="labelAllInterviewersAreDisplayed" runat="server" Visible="true" Text="<%$ Resources:Resource, AllFilteredInInterviewersWillBeDisplayed %>" Width="400px"></asp:Label>
                        </div>
                        <asp:Panel ID="SelectedInterviewerPanel" runat="server">
							<div class="frame">
                            <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server" EnableAJAX="true">
                                <telerik:radtreeview 
                                    id="treeSelectedInterviewers"                            
                                    OnNodeEdit="treeSelectedInterviewers_HandleNodeEdit" 
                                    AllowNodeEditing="True" 
                                    SingleExpandPath="False" 
                                    OnClientNodeDropping="treeSelectedDropTest"                                    
                                    MultipleSelect="True" 
                                    CheckBoxes="True" 
                                    DataValueField="NodeId"
                                    DataTextField="NodeLabel"
                                    DataFieldID="NodeId"
                                    DataFieldParentID="ParentNodeId"
                                    OnNodeDataBound="treeSelectedInterviewers_OnNodeBound"
                                    OnDataBound="treeSelectedInterviewers_OnDataBound"                                    
                                    EnableDragAndDrop="true"
                                    OnNodeDrop="treeSelectedInterviewers_HandleDrop"                                    
                                    EnableDragAndDropBetweenNodes="true"
                                    height="305px" runat="server">
                                </telerik:radtreeview>
                            </telerik:RadAjaxPanel>
                            </div>
                        </asp:Panel>
                    </asp:Panel>
                </asp:Panel>
            </asp:Panel>
        </div>
        </asp:Panel>
    </telerik:RadAjaxPanel>
</asp:Content>
